<?php 

class Report extends MY_Controller
{
    public $module_name;
	function __construct()
    {
        parent::__construct();

        $this->module_name = $this->router->fetch_module();
        $this->load->model('../extensions/'.$this->module_name.'/models/Charges_model');
        $this->load->model('../extensions/'.$this->module_name.'/models/Payment_model');
    
        $global_data['menu_on'] = true;
        $global_data['selected_menu'] = 'reports';      
        $global_data['submenu'] = 'reports/reports_submenu.php';
        $global_data['submenu_parent_url'] = base_url()."reports/";
        $global_data['sidebar_menu_url'] = base_url()."reports/ledger/";
        
        $this->load->vars($global_data);
    }

    function daily_account_summary($date_filter = ''){
        $selling_date = $this->selling_date;
        
        $data['accounting_charges_data'] = $data['accounting_payments_data'] = $data['accounting_taxes_data'] = array();
        
        if(!$date_filter) {
            $date_filter = "$selling_date--$selling_date";
        }
        $dates = explode('--', $date_filter);
        if(count($dates) > 1) {
            $start_date = $dates[0];
            $end_date = $dates[1];
            $month_start_date = date("Y-m-01", strtotime($dates[1]));
            $year_start_date = date("Y-01-01", strtotime($dates[1]));
            $data['accounting_charges_data']['date'] = $this->Charges_model->get_accounting_charges($start_date, $end_date, true);

            $data['accounting_charges_data']['month'] = $this->Charges_model->get_accounting_charges($month_start_date, $end_date, true);

            $data['accounting_charges_data']['year'] = $this->Charges_model->get_accounting_charges($year_start_date, $end_date, true);

            $data['accounting_payments_data']['date'] = $this->Payment_model->get_accounting_payments($start_date, $end_date);

            $data['accounting_payments_data']['month'] = $this->Payment_model->get_accounting_payments($month_start_date, $end_date);

            $data['accounting_payments_data']['year'] = $this->Payment_model->get_accounting_payments($year_start_date, $end_date);

            $data['accounting_taxes_data']['date'] = $this->Tax_model->get_accounting_taxes($start_date, $end_date, true);

            $data['accounting_taxes_data']['month'] = $this->Tax_model->get_accounting_taxes($month_start_date, $end_date, true);

            $data['accounting_taxes_data']['year'] = $this->Tax_model->get_accounting_taxes($year_start_date, $end_date, true);
            
            $data['start_date'] = $start_date;
            $data['end_date'] = $end_date;
            $data['selling_date'] = $selling_date;
        }

        $files = get_asstes_files($this->module_assets_files, $this->module_name, $this->controller_name, $this->function_name);

        $data['selected_submenu'] = 'Ledger'; //for css
        $data['selected_sidebar_link'] = 'Daily Account Summary';

        $data['main_content'] = '../extensions/'.$this->module_name.'/views/daily_account_summary';
        $this->template->load('bootstrapped_template', null , $data['main_content'], $data);
    }

    function download_daily_account_summary_csv_export($date_filter = null)
    {  
       header('Content-Type: text/csv; charset=utf-8');  
        $current_date_total_charges = 0;
        $current_month_total_charges = 0;
        $current_year_total_charges = 0;  
        $current_date_total = 0;
        $current_month_total = 0;
        $current_year_total = 0;    
        $this->load->helper('download');
        $dates = explode('--', $date_filter);
        $selling_date = $this->selling_date;
        if(count($dates) > 1) {
            $start_date = $dates[0];
            $end_date = $dates[1];
        }
        else
        {
            $start_date = $selling_date;
            $end_date = $selling_date;
        }
        $tdate= (end($this->uri->segments) != 'download_daily_account_summary_csv_export') ? ($start_date ." to ". $end_date) : date("Y-m-d", strtotime($end_date));
        $pdate=date("Y-m-01", strtotime($end_date));
        $ydate=date("Y-01-01", strtotime($end_date));           
       
        $csv_keys = array(
            "Name",
            "Today ".$tdate,
            "Period ".$pdate,
            "Year ".$ydate
        );
                    
        $data['accounting_charges_data'] = $data['accounting_payments_data'] = $data['accounting_taxes_data'] = array();        
        if(!$date_filter) {
            $date_filter = "$selling_date--$selling_date";
        }
        $dates = explode('--', $date_filter);
        if(count($dates) > 1) {
            $start_date = $dates[0];
            $end_date = $dates[1];
            $month_start_date = date("Y-m-01", strtotime($dates[1]));
            $year_start_date = date("Y-01-01", strtotime($dates[1]));
            $data['accounting_charges_data']['date'] = $this->Charges_model->get_accounting_charges($start_date, $end_date, true);

            $data['accounting_charges_data']['month'] = $this->Charges_model->get_accounting_charges($month_start_date, $end_date, true);

            $data['accounting_charges_data']['year'] = $this->Charges_model->get_accounting_charges($year_start_date, $end_date, true);

            $data['accounting_payments_data']['date'] = $this->Payment_model->get_accounting_payments($start_date, $end_date);

            $data['accounting_payments_data']['month'] = $this->Payment_model->get_accounting_payments($month_start_date, $end_date);

            $data['accounting_payments_data']['year'] = $this->Payment_model->get_accounting_payments($year_start_date, $end_date);

            $data['accounting_taxes_data']['date'] = $this->Tax_model->get_accounting_taxes($start_date, $end_date, true);

            $data['accounting_taxes_data']['month'] = $this->Tax_model->get_accounting_taxes($month_start_date, $end_date, true);

            $data['accounting_taxes_data']['year'] = $this->Tax_model->get_accounting_taxes($year_start_date, $end_date, true);         
            
            $data['selling_date'] = $selling_date;
        }      

        $booking_row = array();
        $bookings = array($csv_keys);        
      foreach($data['accounting_charges_data']['date'] as $name => $amount){
                if($name === "Selling Date") continue;
        $booking_row = array();                             
        $booking_row[] = $name; 
        $booking_row[] =number_format($data['accounting_charges_data']['date'][$name], 2, ".", ","); 
        $current_date_total_charges += $data['accounting_charges_data']['date'][$name];       
        $booking_row[] = number_format($data['accounting_charges_data']['month'][$name], 2, ".", ","); 
        $current_month_total_charges += $data['accounting_charges_data']['month'][$name];       
        $booking_row[] =  number_format($data['accounting_charges_data']['year'][$name], 2, ".", ","); 
        $current_year_total_charges += $data['accounting_charges_data']['year'][$name];
        $bookings[] = $booking_row;
               }  

        foreach($data['accounting_taxes_data']['date'] as $name => $amount){
                if($name === "Selling Date") continue;
        $booking_row = array();                             
        $booking_row[] = $name; 
        $booking_row[] =number_format($data['accounting_taxes_data']['date'][$name], 2, ".", ",");
        $current_date_total_charges += $data['accounting_taxes_data']['date'][$name];        
        $booking_row[] = number_format($data['accounting_taxes_data']['month'][$name], 2, ".", ",");
        $current_month_total_charges += $data['accounting_taxes_data']['month'][$name];        
        $booking_row[] =  number_format($data['accounting_taxes_data']['year'][$name], 2, ".", ","); 
        $current_year_total_charges += $data['accounting_taxes_data']['year'][$name];
              
        $bookings[] = $booking_row;  
        }         
        $booking_row = array();
        $booking_row[] = '';
        $booking_row[] = number_format($current_date_total_charges, 2, ".", ","); 
        $booking_row[] = number_format($current_month_total_charges, 2, ".", ","); 
        $booking_row[] = number_format($current_year_total_charges, 2, ".", ",");
        $bookings[] = $booking_row;
        
        $booking_row = array();
        $booking_row[] = '';
        $booking_row[] = '';
        $booking_row[] = '';
        $booking_row[] = '';
        $bookings[] = $booking_row;
        foreach($data['accounting_payments_data']['date'] as $name => $amount){
                if($name === "Selling Date") continue;
        $booking_row = array();                             
        $booking_row[] = $name; 
        $booking_row[] =number_format($data['accounting_payments_data']['date'][$name], 2, ".", ",");  
        $current_date_total += $data['accounting_payments_data']['date'][$name];      
        $booking_row[] = number_format($data['accounting_payments_data']['month'][$name], 2, ".", ","); 
        $current_month_total += $data['accounting_payments_data']['month'][$name];       
        $booking_row[] =  number_format($data['accounting_payments_data']['year'][$name], 2, ".", ",");
        $current_year_total += $data['accounting_payments_data']['year'][$name];        
        $bookings[] = $booking_row;    
        }    
        $booking_row = array();
        $booking_row[] = '';
        $booking_row[] = number_format($current_date_total, 2, ".", ","); 
        $booking_row[] = number_format($current_month_total, 2, ".", ","); 
        $booking_row[] = number_format($current_year_total, 2, ".", ",");
        $bookings[] = $booking_row;           
              
        force_download_csv($bookings, "daily_account_summary.csv");
    }
}